require "brains/trmbrain"
require "stategraphs/SGtrm"

local assets =
{
	Asset("ANIM", "anim/hat_fruit.zip"),
	Asset("ANIM", "anim/ds_pig_basic.zip"),
	Asset("ANIM", "anim/ds_pig_actions.zip"),
	Asset("ANIM", "anim/pig_build.zip"),
	Asset("SOUND", "sound/pig.fsb"),
}

local prefabs =
{
		"goldnugget",
    "thulecite",
		"orangegem",
		"yellowgem",
		"greengem",
		"purplegem",
		"gears",

}

local builds = {"pig_build", "pigspotted_build"}

local function ontalk(inst, script)
	inst.SoundEmitter:PlaySound("dontstarve/pig/grunt")
end


local function CalcSanityAura(inst, observer)
		return TUNING.SANITYAURA_SMALL
end


local function ShouldAcceptItem(inst, item)
    return item.prefab == "goldnugget"
end

local function OnGetItemFromPlayer(inst, giver, item)
	inst.GOLDNUGGET_COUNT = inst.GOLDNUGGET_COUNT + 1
	inst.SoundEmitter:PlaySound("dontstarve/pig/oink")
	inst.sg:GoToState("happy")
	inst.components.talker:Say("Got " .. inst.GOLDNUGGET_COUNT .. " Gold.", 2.5)
	if inst.GOLDNUGGET_COUNT == 20 then
		inst.components.container.canbeopened = true
		inst.GOLDNUGGET_COUNT = 0
	end
end

local function OnRefuseItem(inst, item)
	inst.components.talker:Say("No Good!", 2.5)
  inst.sg:GoToState("refuse")
end

local slotpos_3x2 = {}

for y = 1.5, 0.5, -1 do
    for x = 0, 2 do
        table.insert(slotpos_3x2, Vector3(75*x-75*2+75, 75*y-75*2+75,0))
    end
end

local function OnOpen(inst)

end

local function OnClose(inst)

end

local function common()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local sound = inst.entity:AddSoundEmitter()
	local shadow = inst.entity:AddDynamicShadow()
	shadow:SetSize( 1.5, .75 )
  inst.Transform:SetFourFaced()

  inst:AddComponent("talker")
  inst.components.talker.ontalk = ontalk
  inst.components.talker.fontsize = 35
  inst.components.talker.font = TALKINGFONT
  --inst.components.talker.colour = Vector3(133/255, 140/255, 167/255)
  inst.components.talker.offset = Vector3(0,-400,0)

  MakeCharacterPhysics(inst, 50, .5)

  inst:AddComponent("locomotor") -- locomotor must be constructed before the stategraph
  inst.components.locomotor.walkspeed = TUNING.PIG_WALK_SPEED - 1 --3

  inst:AddTag("character")
  inst:AddTag("pig")
  anim:SetBank("pigman")
  anim:PlayAnimation("idle_loop")
  anim:Hide("hat")

  inst:AddComponent("named")
  inst.components.named.possiblenames = {"The Rogue Merchant"}
  inst.components.named:PickNewName()

  inst:AddComponent("inventory")

  inst:AddComponent("knownlocations")

  inst:AddComponent("sanityaura")
  inst.components.sanityaura.aurafn = CalcSanityAura

  inst:AddComponent("inspectable")
  inst.components.inspectable.getstatus = function(inst)
      return "The Rogue Merchant"
  end

	inst:AddComponent("container")
	inst.components.container:SetNumSlots(#slotpos_3x2)

	inst.components.container.onopenfn = OnOpen
	inst.components.container.onclosefn = OnClose

	inst.components.container.widgetslotpos = slotpos_3x2
	inst.components.container.widgetanimbank = "ui_chest_3x2"
	inst.components.container.widgetanimbuild = "ui_chest_3x2"
	inst.components.container.widgetpos = Vector3(0,200,0)
	inst.components.container.side_align_tip = 160
	inst.components.container.ismerchant = true
	inst.components.container.canbeopened = false

	inst:AddComponent("trader")
  inst.components.trader:SetAcceptTest(ShouldAcceptItem)
  inst.components.trader.onaccept = OnGetItemFromPlayer
  inst.components.trader.onrefuse = OnRefuseItem

	--WEAR HAT
	local hat = SpawnPrefab("common/characters/fruithat")
	inst.components.inventory:Equip(hat)
	inst.AnimState:Show("hat")

	--THROW GEM
	inst.GOLDNUGGET_COUNT = 0
	inst.throwThing = function(inst, thing)
		inst:DoTaskInTime(20/30, function()
				inst.SoundEmitter:PlaySound("dontstarve/pig/PigKingThrowGold")
				local nug = SpawnPrefab(thing)
				local pt = Vector3(inst.Transform:GetWorldPosition()) + Vector3(0,4.5,0)

				nug.Transform:SetPosition(pt:Get())
				local down = TheCamera:GetDownVec()
				local angle = math.atan2(down.z, down.x) + (math.random()*60-30)*DEGREES
				--local angle = (-TUNING.CAM_ROT-90 + math.random()*60-30)/180*PI
				local sp = math.random()*4+2
				nug.Physics:SetVel(sp*math.cos(angle), math.random()*2+8, sp*math.sin(angle))
		end)
	end

  return inst
end

local function normal()
    local inst = common()
    inst.build = builds[math.random(#builds)]
    inst.AnimState:SetBuild(inst.build)
		local brain = require "brains/trmbrain"
		inst:SetBrain(brain)
		inst:SetStateGraph("SGtrm")
		inst.AnimState:SetBuild(inst.build)
		inst.components.trader:Enable()
		inst.components.talker:StopIgnoringAll()
    return inst
end

return Prefab( "common/characters/trm", normal, assets, prefabs)
